var vectorBalls_sprites

function vectorBalls_init()
{
	//	precompute	32 bobs with various gradients
	vectorBalls_sprites = [];
	var	gradientColors =
	[
		['#600','#900','#f00','rgba(255,  0,  0,0)'],
		['#666','#999','#fff','rgba(255,255,255,0)'],
		['#369','#09c','#3ff','rgba( 51,255,255,0)'],
		['#036','#069','#0cf','rgba(  0,204,255,0)'],
		['#003','#036','#09c','rgba(  0,102,153,0)']
	]
	while( currentGradient=gradientColors.pop() )
	{
		var	currentGradientBlurredBobs = [];
		for( var i=0; i<32; i++ )
		{
			var currentBlurredBobCanvas		= document.createElement('canvas'),
				currentBlurredBobContext	= currentBlurredBobCanvas.getContext('2d');

			currentBlurredBobCanvas.width = currentBlurredBobCanvas.height = 64;

			focus = .9-(.5*i/32);

			//	colored gradient
			var	grad = currentBlurredBobContext.createRadialGradient( 32+8,32-8,0,32,32,32 );
			grad.addColorStop(  0,		currentGradient[0] );
			grad.addColorStop( focus*.33,	currentGradient[0] );
			grad.addColorStop( focus*.67,	currentGradient[1] );
			grad.addColorStop( focus,	currentGradient[2] );
			grad.addColorStop( 1,		currentGradient[3] );

			currentBlurredBobContext.fillStyle = grad;
			currentBlurredBobContext.fillRect( 0,0,64,64 );



			currentGradientBlurredBobs.push( currentBlurredBobCanvas );
		}
		vectorBalls_sprites.push( currentGradientBlurredBobs );
	}


	//	done
	progressBarIndex++;
}


function vectorBalls_render( currentTime, percentage, extraArguments )
{
	var	offset = percentage*Math.PI*2;

	offScreenCanvasContext.drawImage( backgrounds_red[ 4+(Math.floor(percentage*8)&3)], 0,0 )

//	offScreenCanvasContext.fillStyle = '#fff'	offScreenCanvasContext.fillRect( 0,0,320,160 )



	var g = .67-.33*Math.cos(offset/4)

	focalSize = 24+16*Math.cos(offset*4)

	var n = 125
	for( var i=0; i<n; i++ )
	{
		var x = 160+120*Math.cos(offset*.37+i*Math.PI*6/n)
			y =  80-120*Math.sin(offset*.73+i*Math.PI*7/n)
		size	=  (24+16*Math.cos(offset*1.27+i*.3)) //*(.125+g*.875)
		focus	= Math.round( Math.abs( 32*Math.sin( (focalSize-size)*Math.PI/64) ) ) //(15.5+15.5*Math.cos(offset*5+i*1))*g );
		if( focus<0 )
			focus = 0
		else if( focus>31 )
			focus=31


		offScreenCanvasContext.drawImage( vectorBalls_sprites[i%vectorBalls_sprites.length][ focus ],0,0,64,64,x-size,y-size,size*2,size*2 );
	}


}
